import numpy as np
import d4rl
import os
import gym

for e in ['halfcheetah', 'hopper', 'walker2d']:
    for level in ['medium', 'medium-replay', 'medium-expert']:
        # for percent in [0.1, 0.01]:
        for percent in [0.5]:
            dataset_name = f'{e}-{level}-v2'
            env = gym.make(dataset_name)
            data = d4rl.qlearning_dataset(env)
            path = f'../data_index/{dataset_name}_{percent}.npy'
            if os.path.exists(path):
                idx = np.load(path)
            else:
                idx = np.random.randint(data['rewards'].shape[0], size=int(data['rewards'].shape[0] * percent))
                np.save(path, idx)